 ; Ŀ
 ;   Acla: area class maker.                                               
 ;   Copyright 1999, 2010 by Rocket Software Ltd.                          
 ;   What if it turns out that consciousness is just a simulation?         
 ; 

 ; Ŀ
 ;   Ossify - hatch an ss.                                                 
 ; 
 (DEFUN OSSIFY (ss ansi scal / hasc)
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (setq hasc (* (misps) scal))
  (command "hatch" ansi hasc "0" ss "")
 (princ))
 ; Ŀ
 ;   Ossify end.                                                           
 ; 

 ; Ŀ
 ;   Herro - error handler.                                                
 ; 
 (DEFUN HERRO (shk / pos entt enam sublst vall)
  (setq *error* esav)
  (if clay (setvar "clayer" clay))
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Herro end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Sid: fillet a polyline corner if it is convex.             
 ;   Arguments: Enam - the overall polyline ename                          
 ;              Pprev - the Previous vertex point                          
 ;              Prvnam - the Previous vertex ename                         
 ;              Pvert - the Current vertex point                           
 ;              Vrtnam - the Current vertex ename                          
 ;              Pnext - the Next vertex point                              
 ;              Nexnam - the Next vertex ename                             
 ;              Frad - Fillet radius                                       
 ;                                                                         
 ;   Returns nothing.                                                      
 ; 
 (DEFUN SID (enam pprev prvnam pvert vrtnam pnext nexnam frad / ang1 ang2
                                   angmid bakfil pa prvdis nxdis fipta fiptb)
 ; Ŀ
 ;   Get the angle of each outside vertex from the one to be filleted.     
 ; 
  (setq ang1 (angle pvert pprev))
  (setq ang2 (angle pvert pnext))
 ; Ŀ
 ;   Now find the inside angle of the vertex.                              
 ; 
  (setq angmid (/ (+ ang1 ang2) 2))
  (if (>= (abs (- ang1 ang2)) pi)
      (setq angmid (- angmid pi)))
 ; Ŀ
 ;   Get the distance from the current vertex to each adjacent one.        
 ; 
  (setq prvdis (distance pprev pvert))
  (setq nxdis (distance pnext pvert))
 ; Ŀ
 ;   If either segment length is less than the fillet radius, set the      
 ;   fillet radius Frad to that value, since can't install a fillet        
 ;   longer than either of the segments it is to lie on.                   
 ; 
  (if (< prvdis frad) (setq frad prvdis))
  (if (< nxdis frad) (setq frad nxdis))
 ; Ŀ
 ;   The fillet point is measured away from the current vertex, so the     
 ;   distance to the fillet command pick point is the fillet radius plus   
 ;   half of difference between that and segment length.                   
 ;   Unless the fillet radius Frad is the same as the segment length, in   
 ;   which case set it to the end, i.e. the other vertex.                  
 ; 
  (if (> prvdis frad)
      (setq prvdis (+ frad (/ (- prvdis frad) 2))))
  (if (> nxdis frad)
      (setq nxdis (+ frad (/ (- nxdis frad) 2))))
 ; Ŀ
 ;   Set the fillet radius using the fillet command.                       
 ; 
  (command "fillet" "r" frad)
 ; Ŀ
 ;   Calculate the correct value for Bakfil, the distance from the vertex  
 ;   to the top of the fillet arc.                                         
 ;   Then find the top point.                                              
 ; 
  (setq bakfil (- (* (sqrt 2) frad) frad))
  (setq pa (polar pvert angmid bakfil))
 ; Ŀ
 ;   Now see if the closest point on the fillet to the vertex is inside    
 ;   the polyline. (If so must fillet the vertex.)                         
 ; 
  (if (not (cx enam pa))
      (progn
 ; Ŀ
 ;   Find the fillet pick points.                                          
 ; 
           (setq fipta (polar pvert ang1 prvdis))
           (setq fiptb (polar pvert ang2 nxdis))
 ; Ŀ
 ;   Do it.  Note that the second (ename point) list uses vrtnam and not   
 ;   nexnam, since the second segment is considered part of the vertex     
 ;   before it.                                                            
 ; 
           (command "fillet" (list prvnam fipta) (list vrtnam fiptb))))
 (princ))
 ; Ŀ
 ;   Sid end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine CX: decide whether a point is inside or outside a pline.   
 ;   Arguments: Pl - the polyline ename                                    
 ;              Pta - the test point                                       
 ;                                                                         
 ;   Calls Segtst.                                                         
 ;   Returns T if the point was outside the polyline, otherwise nil.       
 ; 
 (DEFUN CX (pl pta / ints nn nname pasav pa intpt intlst pc)
 ; Ŀ
 ;   Have to check each segment to see if the test line intersects it,     
 ;   and keep a tally of the number of intersections.                      
 ;   A line exactly crossing a vertex will return an intersection for       
 ;   both segments, so keep an intersection list and ignore duplicates.    
 ; 
  (setq ints 0)
  (setq nn (entget (setq nname (entnext pl))))             ; first vertex
  (setq pasav (cdr (assoc 10 nn)))                         ; save location
  (while (/= (cdr (assoc 0 nn)) "SEQEND")
         (setq pa (cdr (assoc 10 nn)))
         (if (and pa pc (setq intpt (segtst pta pa pc)))   ; call inters finder
             (progn
                  (if (not (member intpt intlst))
                      (progn
                           (setq ints (1+ ints))
                           (setq intlst (cons intpt intlst))))))
         (setq pc pa)
         (setq nn (entget (setq nname (entnext nname)))))  ; next vertex
 ; Ŀ
 ;   Check the segment between the last vertex and the start point.        
 ; 
  (if (and pasav pc)
      (if (segtst pta pasav pc)
          (setq ints (1+ ints))))
 ; Ŀ
 ;   If there are 0 or an odd number of intersections the point is         
 ;   outside the polyline (T), otherwise it is inside ().                  
 ; 
 (if (= (/ ints 2) (/ ints 2.0)) T ()))
 ; Ŀ
 ;   CX end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Segtst - see if a polyline segment intersects a line       
 ;   drawn from a point.  Takes the point and segment ends as arguments    
 ;   and returns the intersection point (if any).                          
 ;   The line must be considered to be of infinite length so that it can   
 ;   hit any segment, but the intersection must be on the segment itself   
 ;   so that all tests of nonparallel lines don't produce an intersection. 
 ;   Find the infinite length intersection, measure the distance between   
 ;   that and the start point, make the line that length and do an onseg   
 ;   test.                                                                 
 ; 
 (DEFUN SEGTST (pa segst segend / pb intrs dist)
  (setq pb (polar pa 0 100))
  (setq intrs (inters pa pb segst segend ()))
  (if intrs
     (progn
          (setq dist (1+ (distance pa intrs)))
          (setq pb (polar pa 0 dist))
          (setq intrs (inters pa pb segst segend))))
 intrs)
 ; Ŀ
 ;   Segtst end.                                                           
 ; 

 ; Ŀ
 ;   Sid - Fillet the convex corners on a polyline.                        
 ; 
 (DEFUN CSID (enam frad / enam esav closed entt malist num goon sub prvnam
                                    pprev vrtnam pvert nexnam pnext enext)
  (setq esav enam)
 ; Ŀ
 ;   See if the polyline is closed.                                        
 ; 
  (setq closed (if (= 1 (logand 1 (cdr (assoc 70 (entget enam))))) t)) ; closed
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq enam
                                                          (entnext enam)))))))
         (setq malist (append malist (list enam))))
  (setq num 0)
  (setq goon 3)
  (while (and (> goon 0) (setq sub (nth num malist)))
         (setq num (1+ num))
         (setq prvnam vrtnam)
         (if prvnam (setq pprev (cdr (assoc 10 (entget prvnam)))))
         (setq vrtnam nexnam)
         (if vrtnam (setq pvert (cdr (assoc 10 (entget vrtnam)))))
         (setq nexnam sub)
         (if nexnam (setq pnext (cdr (assoc 10 (entget nexnam)))))
 ; Ŀ
 ;   Wait: filleting will add vertices and shorten lengths, possibly       
 ;   making filleting the next vertex impossible.                          
 ;   New vertices are placed in sequence in the list but enames are added  
 ;   sequentially - existing vertex enames remain unchanged.               
 ;   So: save all existing vertices and check for a new one before each    
 ;   vertex before filleting: do an entnext on the previous one and see    
 ;   if the result is the current one, if not it becomes Prvnam.           
 ;   This method won't work for all pline mods, but it is fast and should  
 ;   be ok for this type of change.                                        
 ;   But: skipping to the next entity may step onto the Seqend.  This      
 ;   being the case, go to the first entity in Malist.                     
 ;   No: if it's Seqend then no new vertex was added, so do nothing.       
 ; 
         (if (and prvnam
                  (not (equal (setq enext (entnext prvnam)) vrtnam))
                  (/= "SEQEND" (cdr (assoc 0 (entget enext)))))
             (progn
                  (setq prvnam enext)
                  (setq pprev (cdr (assoc 10 (entget prvnam))))))
 ; Ŀ
 ;   Now call Sid to make the fillet.                                      
 ;   Don't try to fillet if all three of the point variables aren't        
 ;   defined, or if any two are the same: filleting a segment which is     
 ;   the same length as the segment radius can push the vertex after the   
 ;   fillet onto the next vertex, trying to draw a fillet using a zero     
 ;   length segment will crash the routine.                                
 ; 
         (if (and pprev pvert pnext
                  (not (or (equal pprev pvert) (equal pnext pvert))))
             (sid esav pprev prvnam pvert vrtnam pnext nexnam frad))
 ; Ŀ
 ;   If the polyline is closed, start again at the beginning and run for   
 ;   two more cycles to get the final vertex.                              
 ; 
         (cond ((and closed (= num (length malist)))
                (setq goon 2)
                (setq num 0))
               ((= goon 2) (setq goon 1))
               ((= goon 1) (setq goon 0))))
 (princ))
 ; Ŀ
 ;   Sid end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Plen -return the length of a pline.                        
 ; 
 (DEFUN PLEN (enam / entt pa pb totlen)
  (setq totlen 0)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq pa (cdr (assoc 10 entt)))
         (if (and pa pb)
             (setq totlen (+ totlen (distance pa pb))))
         (setq pb pa))
 totlen)
 ; Ŀ
 ;   Subroutine Plen end.                                                  
 ; 

 ; Ŀ
 ;   Acla.                                                                 
 ; 
 (DEFUN C:ACLA (/ esav *error* clay laynam enampt orig enam totlen pax pasav
                                                               p1 p2 p3 insp)
  (setvar "cmdecho" 0)
  (command "undo" "begin")
  (if (or (null wasp) (null misps))
      (load "misps"))
  (setq dimsc (misps))
  (setq esav *error*)
  (setq *error* herro)
  (setq clay (getvar "clayer"))
  (setq laynam "hatch")
  (if (tblsearch "layer" laynam)
      (setvar "clayer" laynam)
      (command "layer" "m" laynam "c" 6 "" ""))
 ; Ŀ
 ;   First get the polyline to classify.                                   
 ; 
  (setq enampt (entsel "Box: "))
  (setq orig (setq enam (car enampt)))
 ; Ŀ
 ;   Ok, how to find a point guaranteed to be outside a figure?            
 ;   White's theorem: the lengths of all the sides added together          
 ;   pretty well have to be longer than the figure itself.                 
 ; 
  (setq totlen (plen (car enampt)))
  (setq pax (cdr (assoc 10 (entget (entnext enam)))))
  (setq pasav pax)
  (setq pax (polar pax 0 totlen))
 ; Ŀ
 ;   Have an exterior point, Pax, so offset it and save the new ename.     
 ; 
  (command "offset" "3000" enampt pax "")
  (setq p1 (entlast))
 ; Ŀ
 ;   And offset the new figure.                                            
 ; 
  (setq totlen (plen p1))
  (setq pax (cdr (assoc 10 (entget (entnext p1)))))
  (setq pax (polar pax 0 totlen))
  (command "offset" "4500" p1 pax "")
 ; Ŀ
 ;   Now fillet all outside corners on the latest entity.                  
 ; 
  (csid (setq p2 (entlast)) 4500)
  (command "offset" "1000" p2 pasav "")
  (setq p3 (entlast))
 ; Ŀ
 ;   And fillet the first offset one - the Class 1 Div 2 area.             
 ; 
  (csid p1 3000)
 ; Ŀ
 ;   Move the boundary plines onto the Hatch layer.                        
 ; 
  (command "change" p1 p2 p3 "" "p" "layer" "hatch" "")
 ; Ŀ
 ;   Now hatch everything, but ask first: may be combining areas as part   
 ;   of a larger area classification.                                      
 ; 
  (initget 0 "Yes No")
  (Setq insp (getkword "\nApply hatching? <Y>: "))
  (if (or (null insp) (= insp "Yes"))
      (progn
           (command "select" orig "")
           (ossify (ssget "P") "ansi37" 20)   ; Class 1 div 1
           (command "select" enam p1 "")
           (ossify (ssget "P") "ansi31" 20)   ; Class 1 div 2
           (command "select" p2 p3 "")
           (ossify (ssget "P") "ansi31" 20)   ; Class 1 div 2
 ; Ŀ
 ;   And erase the inner 450mm height boundary pline.                      
 ; 
           (command "erase" p3 "")))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (command "undo" "end")
  (setvar "clayer" clay)
  (setq *error* esav)
 (princ))